var NotificationData = (function () {
	// 箭头的方向
	var arrowDirection = {
		none : 0,
		topLeft : 1,
		topRight : 2,
		bottomLeft : 3,
		bottomRight : 4,
		leftTop : 5,
		rightTop : 6,
		leftBottom : 7,
		rightBottom : 8
	};

	// 箭头的风格
	var arrowStyle = {
		common : 0,	//普通三角形
		rightAngle : 1, //直角三角形
		sideling : 2 	//斜三角形
	};
	
	// 通知生存的时间（秒）
	var LIVE_FOREVER = 31536000; // one year
	
	var data = {
		// @see: /src/isomer/extension/api/api_impl/tip_api/api_tip_client.h:32
		options: {
			// 入口文件路径
			file: 'default/cubeui/notification/notification.html',
			// 箭头设置（箭头是页面内用HTML画的，关注param参数）
			arrow: {
				// string 箭头指向的方向
				direction: arrowDirection.none,
				// 箭头顶点位置，如果向左，则是最左边的点
				point: {
					x: 0, // int
					y: 0  // int
				},
				offset: 30,
				style: arrowStyle.common
			},
			// （自动销毁前的）生存时间，单位为秒，注意：0不表示自动销毁（而是生存0秒）
			livetime: LIVE_FOREVER,
			// 传到“通知”页面的数据[optional]
			param: {}
		},
		LOGIN: {
			options: {
				livetime: 7,
				arrow: {
					direction: arrowDirection.topLeft,
					_customPoint: {
						x: 'center',
						y: 'bottom'
					}
				}
			},
			// 本地没有缓存的网络收藏数据
			ACCOUNT_NO_LOCAL_BOOKMARK: {
				options: {
					param: {
						content: '连接QQ帐户，收藏随身带，服务轻松用',
						action:  [
							{
								type: 'button',
								value: '我知道了',
								event: 'qqbrowser.tip.destroyMe();qqbrowser.extension.builtin.config.set({educateLoginNotify: false}, function() {});'
							}
						],
						closeAdditionalEvent: 'qqbrowser.extension.builtin.config.set({educateLoginNotify: false}, function() {});'
					}
				},
				ONCE: true,
				CONFIG_KEY: 'educateLoginNotify'
			},
			// 本地有缓存的网络收藏数据
			ACCOUNT_HAS_LOCAL_BOOKMARK: {
				options: {
					livetime: LIVE_FOREVER,
					param: {
						title: '收藏已备份到QQ帐号下',
						content: '登录即可使用',
						action: [
							{
								type: 'button',
								value: '登录QQ帐号',
								css: {
									width: '100%'
								},
								event: 'qqbrowser.account.login();qqbrowser.extension.builtin.config.set({loginNotify: false}, function() {});qqbrowser.tip.destroyMe();'
							}
						],
						closeAdditionalEvent: 'qqbrowser.extension.builtin.config.set({loginNotify: false}, function() {});'
					}
				},
				ONCE: true,
				CONFIG_KEY: 'loginNotify'
			},
			// 不允许修改收藏（离线状态）
			BOOKMARK_READONLY: {
				options: {
					param: {
						content: '尚未登录，无法同步您的修改',
						action: [
							{
								type: 'button',
								value: '我知道了',
								autofocus: true,
								event: 'qqbrowser.tip.destroyMe();'
							}
						]
					}
				}
			}
		},
		ENGINE: {
			options: {
				livetime: 10,
				arrow: {
					direction: arrowDirection.topRight,
					_customPoint: {
						x: 'center',
						y: 'bottom'
					}
				}
			},
			// 强名单内核切换通知
			COMPULSORY_CORE_TYPE: {
				options: function(data) {
					return {
						_dataReportId: 1110101,
						param: {
							title: '此网站只适合兼容模式',
							content: '切换后可能导致无法正常显示，建议保留当前模式',
							action: [
								{
									type: 'button',
									value: '我知道了',
									autofocus: true,
									event: 'qqbrowser.extension.builtin.statistics.increase(1110107);qqbrowser.tip.destroyMe();'
								},
								{
									type: 'link',
									value: '继续切换',
									event: ['qqbrowser.tabs.coreSwitch(', data.pageId, ');qqbrowser.extension.builtin.statistics.increase(1110102);qqbrowser.tip.destroyMe();'].join('')
								}
							],
							closeAdditionalEvent: 'qqbrowser.extension.builtin.statistics.increase(1110108);'
						}
					}
				}
			},
			// 推荐名单内核切换通知
			MISMATCHED_CORE_TYPE: {
				options: function(data) {
					return {
						_dataReportId: data.coreType === 0 ? 1110103 : 1110105,
						param: {
							// CORE_TYPE.IE: 0
							title:  data.coreType === 0 ? '已为您智能切换至兼容模式' : '已为您智能切换至极速模式',
							content: '您上次选择的模式可能导致此网站无法正常显示',
							action: [
								{
									type: 'button',
									value: '我知道了',
									autofocus: true, 
									// 推荐名单的“我知道了”在config记一个标志为，以后不再提示
									event: ['qqbrowser.extension.builtin.statistics.increase(', data.coreType === 0 ? 1110109 : 1110111, ');qqbrowser.extension.builtin.config.set({showCoreSwitchTip: false}, function() {qqbrowser.tip.destroyMe();});'].join('')
								},
								{
									type: 'link',
									value: '继续切换',									
									event: ['qqbrowser.tabs.coreSwitch(', data.pageId, ');qqbrowser.extension.builtin.statistics.increase(', data.coreType === 0 ? 1110104 : 1110106, ');qqbrowser.tip.destroyMe();'].join('')
								}
							],
							closeAdditionalEvent: ['qqbrowser.extension.builtin.statistics.increase(', data.coreType === 0 ? 1110110 : 1110112, ');'].join('')
						}	
					};
				}
			}
		},
		STATUSBAR: {
			options: {
				livetime: 10,
				arrow: {
					direction: arrowDirection.bottomRight,
					_customPoint: {
						x: 'center',
						y: 'top'
					}
				}
			},
			POPUP_BLOCK: {
				options: {
					livetime: 6,
					param: {
						icon: 'images/tip_icon.png',
						title: '有弹出窗口被拦截',
						content: '有1个弹出窗口被拦截，要打开被拦截的窗口请单击此按钮...'
					}
				}
			},
			SOUND_CONTROL: {
				options: function(data) {
					return {
						livetime: 3,
						param: {
							icon: data.isMute ? 'images/close_icon.png' : 'images/open_icon.png',
							content: data.isMute ? 'QQ浏览器已进入静音状态！' : 'QQ浏览器的声音已开启！'
						}
					};
				}
			},
			CLOUD_DICT: {
				options: {
					livetime: 5,
					param: {
						icon: 'images/cloud_icon.png',
						content: 'QQ云词典已开启，在当前网页选中单词就可以翻译哦~常来用用'
					}
				}
			},
			DOWNLOAD_EDU: {
				options: {
					param: {
						icon: 'images/download_icon.png',
						title: '下载提示',
						content: '您可以在此查看下载任务'
					}
				}
			},
			DONWLOAD_AUTO_CONTINUE: {
				options: {
					param: {
						icon: 'images/download_icon.png',
						title: '断点续传',
						content: '正在下载上次未完成的任务...'
					}
				}
			},
			SECURE: {
				options: function(data) {
					var levelData = {
						evil: {
							icon: 'images/tip_evil.png',
							content: '受到了恶意网页侵害，QQ浏览器已为您阻止。',
							action: [
								{
									type: 'link',
									value: '为我的电脑提升安全等级',
									event: 'qqbrowser.tabs.create("http://guanjia.qq.com/", 0);qqbrowser.tip.destroyMe();'
								}
							]
						},
						protect: {
							icon: 'images/tip_protect.png',
							content: 'QQ浏览器正在保护您浏览的网页。',
							action: [
								{
									type: 'link',
									value: '了解更多',
									event: 'qqbrowser.tabs.create("http://browser.qq.com/help/cjwt.html#safe",2, 0);qqbrowser.tip.destroyMe();'
								}
							]
						},
						safe: {
							icon: 'images/tip_safe.png',
							content: '在QQ浏览器访问该网址非常安全。',
							action: [
								{
									type: 'link',
									value: '了解更多',
									event: 'qqbrowser.tabs.create("http://browser.qq.com/help/cjwt.html#safe",2, 0);qqbrowser.tip.destroyMe();'
								}
							]
						}
					};

					return {livetime: 6, param: levelData[data.level]};
				}
			}
		}
	};
	
	return data;
})();